# 程序名：envcontractmake.input
# 功能：环境检测技术服务合同技术附件自动生成WORD文档
#       由LIMS系统出的EXCEL数据表格，格生成WORD文件
# 程序设计 ：楼春辉 
# 最后修改日期：2022-11-17
import openpyxl
from openpyxl.cell import MergedCell
from docx import Document
from copy import deepcopy
import os

# 获取项目基本信息
def get_projectinfo(sheet):
    if sheet['G8'].value == None:
        ts = ''
    else:
        ts = sheet['G8'].value
    res = {
        '项目名称': sheet['G3'].value,  
        '项目编号':sheet['AI3'].value,
        '委托单位':sheet['G4'].value,  
        '委托单位地址':sheet['AI4'].value,
        '受检单位':sheet['G5'].value,  
        '受检单位地址':sheet['AI5'].value,
        '联系人':sheet['G6'].value,    
        '联系电话':sheet['U6'].value,
        '报告用途':sheet['G7'].value,
        '分包信息': ts
        }
    return res

# 获取检测结果信息
def get_testinfo(sheet1):
    # 检测是否有合并单元格，或是合并单元格，则取左上角的值
    def parser_merged_cell(sheet1, row, col):
      cell = sheet1.cell(row = row, column = col)
      if isinstance(cell, MergedCell):  # 判断该单元格是否为合并单元格
          for merged_range in sheet1.merged_cells.ranges:  # 循环查找该单元格所属的合并区域
              if cell.coordinate in merged_range:
                  # 获取合并区域左上角的单元格作为该单元格的值返回
                  cell = sheet1.cell(row=merged_range.min_row, column=merged_range.min_col)
                  break
      return cell.value

    rowcount = sheet1.max_row - 18    # EXCLE表格中的数据行数
    res=[]
    for i in range(1, rowcount+1):
        j= i + 11
        data = { 
            '检测类别': parser_merged_cell(sheet1, j, 1),  # 读取合并单位格的数据
            '点位编号': sheet1['D%d' % j].value,
            '点位名称': sheet1['G%d' % j].value,
            '检测项目': sheet1['M%d' % j].value,
            '频次': sheet1['AX%d' % j].value
            }
        res.append(data)
    return res

# 替换WORD文档的内容 
def wd_replace(doc, old_str, new_str):
    # 功能：替换文字 参数 doc: 要替换的文档  old_word: 被替换的文字 new_word: 替换后的文字
    # 本替换可以保持格式不变 ，返回值：无
        for para in doc.paragraphs:                             # 遍历文档段落
            for run in para.runs:                               # 遍历段落的字块
                run.text = run.text.replace(old_str, new_str)   # 替换字块的文字

        # 遍历文档的表格
        for table in doc.tables:                                            
            for row in table.rows:                                          # 表格行
                for cell in row.cells:                                      # 单元格
                    for para in cell.paragraphs:                            # 遍历文档段落
                        for run in para.runs:                               # 遍历段落的字块
                            run.text = run.text.replace(old_str, new_str)   # 替换字块的文字
# ---------------------------------------------------------------------------------------------

# 生成WORD文档
def make_docx(mbdoc, projectinfo,test_result_list):
    # 执行文字替换操作
    wd_replace(mbdoc,'$WTDW', projectinfo['委托单位'])
    wd_replace(mbdoc,'$WT_ADD', projectinfo['委托单位地址'])
    wd_replace(mbdoc,'$SJDW', projectinfo['受检单位'])
    wd_replace(mbdoc,'$CY_ADD', projectinfo['受检单位地址'])
    wd_replace(mbdoc,'$LXR', projectinfo['联系人'])
    wd_replace(mbdoc,'$TEL', projectinfo['联系电话'])
    wd_replace(mbdoc,'$PJ_NAME', projectinfo['项目名称'])
    wd_replace(mbdoc,'$PJ_NO', projectinfo['项目编号'])
    if projectinfo['分包信息'] =='':
        s1,s2 = '',''
    else:
        s1 = projectinfo['分包信息'].split('分包')[0]
        s1 = projectinfo['分包信息'].split('分包')[1]

    wd_replace(mbdoc,'$FB_XM', s1)
    wd_replace(mbdoc,'$CBF', s2)
    
    table = mbdoc.tables[1]
    # 默认表格中仅3行，若数据量较大，在表格中插下相应空行数量
    rowcount = len(test_result_list)
    print("1、数据总行数：%d行，正在增加表格空行%d行..." % (rowcount,rowcount-3))
    if rowcount > 3:  
        for i in range(1, rowcount-2):
            new_row = deepcopy(table.rows[3])               # 连续插入多行，这一句也必须重复
            table.rows[3]._tr.addnext(new_row._element)     # 将复制的内容插在第7行之后
    print("   表格空行增加成功！")
    
    # 在表格中写入检测结果数据
    print("2、正在往空行中填充检测结果数据...")
    for i in range(0,rowcount):
        line = i + 1
        table.rows[line].cells[0].paragraphs[0].text = str(test_result_list[i]['点位编号'])
        table.rows[line].cells[1].paragraphs[0].text = test_result_list[i]['检测类别']
        table.rows[line].cells[2].paragraphs[0].text = test_result_list[i]['点位名称']
        table.rows[line].cells[3].paragraphs[0].text = test_result_list[i]['检测项目']
        table.rows[line].cells[4].paragraphs[0].text = str(test_result_list[i]['频次'])
        table.rows[line].cells[5].paragraphs[0].text = '同意使用中一检测标准'
        table.rows[line].cells[6].paragraphs[0].text = ''
    print("   数据写入完成！")
    file = (filename_output % projectinfo['项目编号'])
    mbdoc.save(file)    # 另存为WORD文档
    print("3、数据结果文件已生成。\n   文件名：%s" % file)
# ---------------------------------------------------------------------------------------------

def get_filepathname(filename, default_dir="D:\\temp\\"):
    # ------------------------------------------------------------------
    if filename.find('\\') == -1:             
        filename  = default_dir + filename          # 若文件名未包含路径信息，则加上全路径
    return filename
# -----------------------------------------------------------------------------


def get_lastfilename(dir):
    # 功能：获取某目录下最新生成的文件名
    result = os.popen("DIR /O-D /B " + dir)   # 返回的结果是一个对象，需要读取后才能处理
    context = result.read()
    result.close()
    line = context.splitlines() 
    return line[0]
    
# 主程序开始
# --------------------------------------
if __name__ == "__main__" :
    input_dir = "C:\\Users\\106-1\\下载\\"
    output_dir = "D:\\temp\\"
    fn = input_dir + get_lastfilename(input_dir)
    filename_input = input("请数据源文件名(扩展名.xlsx)：[%s]" % fn )    # 输入文件名
    if filename_input == "":
        filename_input = fn
    else:
        filename_input = input_dir + filename_input + ".xlsx"                  # 取得文件全路径
    
    filename_output = output_dir + "%s.docx"                                   # 输出的文件位置及文件名
    filename_template = "D:\\mypython\\浙江中一\\mb.docx"               # 模板文件
    
    if not os.path.isfile(filename_input):
        print("文件名%s不存在" % filename_input)
        exit() 
    wb = openpyxl.load_workbook(filename_input)
    sheet1 = wb.worksheets[0]               # 也可使用sheet1 = wb['sheet1']
    pjinfo = get_projectinfo(sheet1)        # 获取项目信息
    test_res = get_testinfo(sheet1)         # 获取测试数据
    wb.close()

    # 输出结果
    print("项目编号：%s\n项目名称：%s\n委托单位：%s\n受检单位：%s" % (pjinfo['项目编号'], pjinfo['项目名称'],pjinfo['委托单位'],pjinfo['受检单位']))
    #print("%-3s %-20s %-20s %-40s %-3s" % ("点位编号","检测类别","点位名称","检测项目","频次"))
    #for line in test_res:
    #    print("%s %s %s %s %s" % (line['点位编号'],line['检测类别'],line['点位名称'],line['检测项目'],line['频次']) )

    mbdoc = Document(filename_template)        # 写入WORD文档
    make_docx(mbdoc,pjinfo,test_res)            # 将数据填写到WORD文档模板中另存为fdoc

    print('4、程序运行已完成。')
    print("****************************")
    input("按回车键结束程序。")
# ----------------------------------------