# 需要先安装 pip install pyMuPDF  所对应的库为fitz
import fitz
import os
import datetime

# =================================================================================
def pyMuPDF_fitz(pdfPath, imagePath):
    startTime_pdf2img = datetime.datetime.now()                         #开始时间
    # print("转换后的图片路径：" + imagePath)
    pdfDoc = fitz.open(pdfPath)
    for pg in range(pdfDoc.page_count):
        page = pdfDoc[pg]
        rotate = int(0)
        # 每个尺寸的缩放系数为1.25，这将为我们生成分辨率提高的图像。
        # 倍率 若不做设置，默认图片大小为：792X612, dpi = 96
        zoom_x = 1.25          
        zoom_y = 1.25
        mat = fitz.Matrix(zoom_x, zoom_y).prerotate(rotate)
        pix = page.get_pixmap(matrix=mat, alpha=False)
        if not os.path.exists(imagePath):                               # 判断存放图片的文件夹是否存在
            os.makedirs(imagePath)                                      # 若图片文件夹不存在就创建
        pix._writeIMG(imagePath+'/'+'images_%s.png' % pg, format = 0)   # 将图片写入指定的文件夹内  格0 PNG
    endTime_pdf2img = datetime.datetime.now()                           # 结束时间
    print('\t转换耗时 %d 微秒' % (endTime_pdf2img - startTime_pdf2img).microseconds)

# ==================================================================================
def dos_cmd(cmd):
    # 功能：获取某目录下最新生成的文件名
    result = os.popen(cmd)              # 返回的结果是一个对象，需要读取后才能处理
    context = result.read()
    result.close()
    return context

# ===================================================================================
def get_lastfilename(dir):
    # 功能：获取某目录下最新生成的文件名
    result = os.popen("DIR /O-D /B " + dir)              # 返回的结果是一个对象，需要读取后才能处理
    context = result.read()
    result.close()
    line = context.splitlines() 
    return line[0]
    
if __name__ == "__main__":
    # 输入文件目录及文件名
    pdf_dir =  'd:\\temp\\pdf转换\\input'
    pdf_filename = get_lastfilename(pdf_dir)  
    s = input("请输入需要换换的文件名([%s\\%s])：" % (pdf_dir, pdf_filename) )
    if s == '':
        pdf_filename = pdf_dir + '\\'+ pdf_filename
    else:
        pdf_filename = pdf_dir + '\\'+ s + '.pdf'
    print("================================================================")
        
    output_dir = 'd:\\temp\\pdf转换\\output'        # 输出文件目录及文件名
    dos_cmd("DEL %s /Q" % output_dir)               # 清除输出文件目录

    image_path = 'd:\\temp\\pdf转换\\output'
    print("*** 您的PDF文件为：%s" % pdf_filename)
    print("*** 正在为您将PDF文件转换为PNG图片")
    pyMuPDF_fitz(pdf_filename, image_path)          #执行转换
    print("*** 转换完成,图片文件保存在：%s" % image_path)
    print("================================================================")
    input("按回车键关闭窗口")